#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

bool uporedi(pair<int, int>& a, pair<int, int>& b) {
    return a.first < b.first;
}

int main() {
    int N, K;
    cin >> N >> K;

    vector<pair<int, int>> trkaci;

    for (int i = 0; i < N; ++i) {
        int x, v;
        cin >> x >> v;
        trkaci.push_back({x, v});
    }

    sort(trkaci.begin(), trkaci.end(), uporedi);

    double left = 0, right = 1e9;

    while (right - left > 1e-7) {
        double mid = (left + right) / 2;
        int brojac = 0;

        for (int i = 0; i < N; ++i) {
            for (int j = i + 1; j < N; ++j) {
                double vreme_i = trkaci[i].first + mid * trkaci[i].second;
                double vreme_j = trkaci[j].first + mid * trkaci[j].second;

                if (vreme_i < vreme_j) {
                    brojac++;
                }
            }
        }

        if (brojac >= K) {
            right = mid;
        } else {
            left = mid;
        }
    }

    cout << fixed << right << endl;

    return 0;
}